package music;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class Compilation extends Album {
	
	private int noOfPerformers;

	public Compilation(String title, Performer performer, int year, Song[] songs, ArrayList<String> credits,
			GregorianCalendar releaseDate, int noOfPerformers) {
		super(title, performer, year, songs, credits, releaseDate);
		this.noOfPerformers = noOfPerformers;
	}

    public void display() {
    	SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        // System.out.println(this.title);
        // System.out.println(this.year);
    	super.display();
    	System.out.println("Compilation:");
        System.out.println("Album: " + this.getTitle() + " (" + this.getYear() + "), " + df.format(getReleaseDate().getTime()));
        System.out.println("Songs: ");
        for (int i = 0; i < getSongs().length; i++) {
            System.out.println('\t' + getSongs()[i].getTitle());
        }
        System.out.println("Credits: ");
        for (int i = 0; i < getCredits().size(); i++) {
            System.out.println('\t' + getCredits().get(i));
        }
    }
    
    public void superDisplay() {
    	super.display();
    }
    
	public int getNoOfPerformers() {
		return noOfPerformers;
	}

	public void setNoOfPerformers(int noOfPerformers) {
		this.noOfPerformers = noOfPerformers;
	}

}
